<htm>
	
	<head>
		<title>Wetterdaten</title>	
		<meta charset="utf-8">
		<link rel="stylesheet" href="styles.css">
	</head>
	
	<body>
		
		<header>
			<?php include "head.php" ?>
		</header>
		
		<div class="wrapper">
		
			<nav>
				<?php include "navi.php" ?>
			</nav>
			
			<main>
			    <table>
				    <tr>
				    	<th>Datum</th>
				    	<th>Temperatur</th>
				    	<th>Feuchte</th>
				    	<th>Windstärke</th>
				    	<th>Sonnenstunden</th>
				    	<th>Bedeckung</th>
				    	<th>Niederschlag</th>
				    	<th>Luftdruck</th>
				    </tr>
				
					<?php
					
						$sid = $_GET['sid'];
						$monat = $_GET['monat'];
						
						include "dbconnect.php";
					
					    $sql = "SELECT Wetterstation.Standort as Standort, Datum, Qualitaet, Mittel_2m, Relative_Feuchte, Mittel_Windstaerke, Sonnenscheindauer, Mittel_Bedeckungsgrad, Niederschlagshoehe, Mittel_Luftdruck FROM Wettermessung, Wetterstation WHERE Stations_ID=? and Datum like ? and Wetterstation.S_ID=Wettermessung.Stations_ID";
					    $stm = $pdo->prepare($sql);
	
					    $stm->execute(array($sid, "2021-".$monat."-%"));
					    
					    
					    $title = false;
					    while ($row = $stm->fetchObject()) {
					    	
					    	if(!$title) {
					    		echo "<h1>Zeitreihe für " . $row->Standort . "</h1>";
					    		$title = true;
					    	}
							
							echo "<tr>";
							echo "<td>" . $row->Datum . "</td>";
							if($row->Mittel_2m < 0) {
						    	echo "<td class='kalt'>" . $row->Mittel_2m . "</td>";
							} else {
						    	echo "<td class='warm'>" . $row->Mittel_2m . "</td>";
							}
					    	echo "<td>" . $row->Relative_Feuchte . "</td>";
					    	echo "<td>" . $row->Mittel_Windstaerke . "</td>";
					    	echo "<td>" . $row->Sonnenscheindauer . "</td>";
					    	echo "<td>" . $row->Mittel_Bedeckungsgrad . "</td>";
					    	echo "<td>" . $row->Niederschlagshoehe . "</td>";
					    	echo "<td>" . $row->Mittel_Luftdruck . "</td>";
					    	echo "</tr>";
					    }
					    
					            
					    $stm = null;
					    $pdo = null;						
											
					?>
					
					</tr>
				</table>
				
			</main>
			
		</div>	
		
	</body>
	
</htm>


